/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xsession.h
 * -----------------------------------------------------------------*/

#ifndef XSESSION_H_INCLUDED
#define XSESSION_H_INCLUDED

#include <xpropdef.h>
#include <xversion.h>

#ifdef __cplusplus
extern "C" {
#endif

/* This is for production only */
bx_porttype EXPORT BestXGetportProduction(bx_handletype handle);
bx_portnumtype EXPORT BestXGetportnumProduction(bx_handletype handle);
bx_int32 EXPORT BestXGetentered_portProduction(bx_handletype handle);

/* *********************************************************************
   Connections and opening. This functions do not exist in firmware
   ********************************************************************* */


#ifndef BEST_FIRMWARE

#define CONNECT_EXCLUSIVE  2
#define CONNECT_NORMAL     1

/* control functions */

void    BestXConnectTimeoutSet (bx_handletype handle, bx_int32 ms);
void    BestXConnectTimeoutDefSet (bx_handletype handle);


/* -----------------------------------------------------------------------
 * Session Functions
 * ----------------------------------------------------------------------- */

bx_errtype EXPORT BestXOpen
(
  bx_handletype  *handle,
  bx_porttype    port,
  bx_int32       portnum
);

bx_errtype EXPORT BestXFastOpen
(
  bx_handletype  *handle,
  bx_porttype    port,
  bx_int32       portnum
);

/* BestXOpenAdv

   !! undocumented function

   The underlaying open function that actually performs the task. All open
   functions call BestXOpenAdv with an according parameter set. This function
   is for internal use only

   arguments:
   handle    - reference to the returned handle, result of this function
   port        - port for connection
   portnum    - details on port
   license_code - returns license information to the caller if the
             BX_OPEN_LICENSE task is specified. In this case provide
          an array of at least 3 longs. The first long returns the
          board license, the other fields are reserved. NULL is legal.
   task        - special tasks during open.

   return value:
   BX_E_OK
   BX_E_CAPI_VERSION_CHECK
   BX_E_HANDLE_NOT_OPEN
   BX_E_NO_HANDLE_LEFT
   BX_E_WRONG_PORT
   BX_E_RS232_OPEN
   BX_E_PARALLEL_OPEN
   BX_E_PCI_OPEN
   BX_E_USB_OPEN
   BX_E_IO_OPEN
*/

bx_errtype EXPORT BestXOpenAdv( /* advanced open call for GUI and failsafe */
  bx_handletype  *handle,       /* open. BestXOpen calls this*/
  bx_porttype    port,          /* function. */
  bx_int32       portnum,
  bx_int32 *license_code,
  bx_OpenType task,
  bx_int32 SoftForce,
  bx_charptrtype filename       /* FX2 firmware to download */
);

bx_errtype EXPORT BestXClose(
  bx_handletype handle
);


bx_errtype EXPORT BestXCloseAdv(
  bx_handletype handle,
  bx_closetype    task
);

bx_errtype EXPORT BestXReopen ( /* closes and opens a card that was open */
  bx_handletype handle,         /* does not change! */
  bx_OpenType   task
);

bx_errtype BestXFirstFreeHandleGet(
  bx_handletype * handle
);

bx_errtype EXPORT BestXBasicIsBoardReset(
  bx_handletype handle,
  bx_int32 *fBoardWasReset
);


CLI bx_errtype EXPORT  BestXRS232BaudRateSet(   /* @brset */
  bx_handletype handle,
  bx_int32 baudrate                             /* @baud */
);


bx_errtype EXPORT BestXDebug(
  bx_handletype handle,
  bx_int32      debug
);

#ifndef SWIG

  bx_errtype EXPORT BestXGetDebugOutFromHandle( bx_handletype handle,
                        void     (**std_out)  (char *,...) );
#endif

bx_errtype EXPORT BestXGetPortFromHandle(
  bx_handletype handle,
  bx_porttype   *port
);

bx_errtype EXPORT BestXGetPortnumberFromHandle(
  bx_handletype handle,
  bx_int32      *portnumber
);

bx_errtype EXPORT BestXGetHWFromHandle(
  bx_handletype handle,
  bx_hwtype     *hw
);

bx_errtype EXPORT BestXGetHWSeriesFromHandle(
  bx_handletype   handle,
  bx_hwseriestype *hw
);

bx_errtype EXPORT BestXGetPciDevIdFromHandle(
  bx_handletype handle,
  bx_int32 * dev_id
);

bx_errtype EXPORT BestXGetProductstringFromHandle(
  bx_handletype handle,
  bx_charptrtype * pChar
);

bx_bool    EXPORT BestXIsOpen(bx_handletype handle);
bx_bool    EXPORT BestXIsKnown(bx_handletype handle);
bx_bool    EXPORT BestXIsOffline(bx_handletype handle);
bx_bool    EXPORT BestXHasFastHost(bx_handletype handle);
bx_bool    EXPORT BestXHasMephisto(bx_handletype handle);
bx_bool    EXPORT BestXIsMode2(bx_handletype handle);
bx_bool    EXPORT BestXIsQDR(bx_handletype handle);
bx_bool    EXPORT BestXHasFaust(bx_handletype handle);
bx_bool    EXPORT BestXHasFaustFPGA(bx_handletype handle);
bx_bool    EXPORT BestXHasPerformance(bx_handletype handle);
bx_bool    EXPORT BestXFaustLoadError(bx_handletype handle);
bx_bool    EXPORT BestXIsDeep(bx_handletype handle);
bx_bool    EXPORT BestXIsCompact(bx_handletype handle);
bx_bool    EXPORT BestXIsCore(bx_handletype handle);
bx_bool    EXPORT BestXIsInBlockMode(bx_handletype handle);
bx_bool    EXPORT BestXIsInDirectMode(bx_handletype handle);
bx_bool    EXPORT BestXHasFirmware(bx_handletype handle);

void BestXHwBlockModeBitSet(bx_handletype handle, bx_bool fSet);
void BestXHwDirectModeBitSet(bx_handletype handle, bx_bool fSet);

void    BestXHwBitMaskSet(bx_handletype handle, bx_int32 mask, bx_bool fSet);
bx_bool BestX16BitRegisterFile (bx_handletype handle);


#ifndef SWIG
bx_errtype EXPORT BestXPortScan(
  int * pNumInstances,
  BX_DEVICE_DATA ** ppDevArr
);

bx_errtype EXPORT BestXPortQuickPing(
  bx_porttype port,          
  unsigned long portnum,
  BX_DEVICE_DATA * pDevStruct
);

bx_errtype EXPORT BestXIsDutHost(
  bx_porttype port,               /* BX_PORT_RS232 etc. */
  unsigned long portnum,          /* 0,1 etc */
  bx_charptrtype pSerialNum,      /* NULL => use port/portnum */
  bx_bool * fDutIsInHost          /* returns 0 or 1 */
);


/*****************************************************************************
 * get number and names of models available with this XCAPI
 *****************************************************************************/
bx_errtype EXPORT BestXGetCardTypeCount(size_t * pCount);

bx_errtype EXPORT BestXGetCardTypeAtIndex(
  bx_param_stringlisttype * pCardList, 
  size_t idx
);

/* How to find out if a PCI device id belongs to a (any) BestX Card
 */
bx_bool  EXPORT BestXIsPciDeviceIdBestX(bx_int32 deviceid);

/* The correct way of finding out what series of board you're
 * connected to
 */
  bx_hwseriestype EXPORT BestXHwSeriesGet(bx_handletype handle);

#endif


CLI bx_errtype EXPORT BestXDirectRegLogOpen ( /* @directreglogopen */
  bx_handletype handle,
  const char * filename    /* @file $"c:\\bx_direct0.txt" */
);




/* -----------------------------------------------------------------------
 * Connection Functions
 * ----------------------------------------------------------------------- */

CLI  bx_errtype EXPORT BestXConnect(                     /* @con */
  bx_handletype handle
);


CLI  bx_errtype EXPORT BestXDisconnect(                     /* @discon */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXConnectEx(                     /* @conex */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXDummySet (            /* @dummyset */
  bx_handletype handle,
  bx_int32 value            /* @val */
);

CLI  bx_errtype EXPORT BestXDummyGet (            /* @dummyget */
  bx_handletype handle,
  bx_int32 *value            /* #RETURN "value=%08x" */
);

CLI  bx_errtype EXPORT BestXPing (            /* @ping */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXClockSet (            /* @clkset */
  bx_handletype handle,
  bx_int32 clkvalue        /* @val */
);

CLI  bx_errtype EXPORT BestXClockGet (            /* @clkset */
  bx_handletype handle,
  bx_int32 *clkvalue        /* #RETURN "clock=%ds */
);

CLI  bx_errtype EXPORT BestXDirectRegWrite(                    /* @drw */
  bx_handletype handle,
  bx_int32 dir_addr,     /* @dad */
  bx_int32 regsize,      /* @size */
  bx_int32 reg_value     /* @val */
);

bx_errtype EXPORT BestXDirectRegBlockWrite(
  bx_handletype handle,
  bx_int32      address,  
  bx_int32      regsize,  
  bx_int32      autoinc,  
  bx_int8ptr    data,   
  bx_int32      datatype,
  bx_int32      numbytes
);

CLI  bx_errtype EXPORT BestXDirectRegRead(                    /* @drr */
  bx_handletype handle,
  bx_int32 dir_addr,     /* @dad  */
  bx_int32 regsize,      /* @size */
  bx_int32 *reg_value    /* #RETURN "0x%08lx" */
);

CLI  bx_errtype EXPORT BestXDirectRegFaustFlashRead(   /* @drffr */
  bx_handletype handle,
  bx_int32 dir_addr,     /* @dad  */
  bx_int32 *reg_value    /* #RETURN "0x%08lx" */
);

bx_errtype EXPORT BestXDirectRegBlockRead(
  bx_handletype handle,
  bx_int32      address,  
  bx_int32      regsize,  
  bx_int32      autoinc,  
  bx_int8ptr    data,     
  bx_int32      datatype,
  bx_int32      numbytes
);

#ifndef SWIG
CLI bx_errtype EXPORT BestXDirectBlockRead( /* @dbr */
  bx_handletype handle,
  bx_int32      address,  /* @addr */
  bx_int32      regsize,  /* @size */
  bx_int32      autoinc,  /* @inc $0 */
  bx_int32      datatype, /* @type $4 */
  bx_int32      numbytes, /* @nob */
  bx_int8 *     data      /* #RETURN intelhexdump(data,numbytes,cmd,NULL,NULL) [numbytes] */
);
#else
/* chris: 
   Do not change the parameter names !
   SWIG relies on that 
*/
bx_errtype EXPORT BestXDirectBlockRead( 
  bx_handletype handle,
  bx_int32      address,
  bx_int32      regsize,
  bx_int32      autoinc,
  bx_int32      datatype,
  bx_int32      NumBytesFor8BitDataOut,
  bx_int8 *     DataFor8BitDataOut
);
#endif



CLI bx_errtype EXPORT BestXDirectRegMaskWrite (  /* @drmw */
  bx_handletype handle,
  bx_int32 address,     /* @dad */
  bx_int32 regsize,     /* @size */
  bx_int32 mask,
  bx_int32 value        /* @val */
);

bx_vertype EXPORT *  xcapi_version(bx_int32 type);


#endif /* not firmware */

/* -----------------------------------------------------------------------
 * resource locking
 *
 * The following functions lock or unlock a requested resource to the
 * calling port. Only this port then has access rights for changing
 * settings of that port or start any action. Readings are allowed for all
 * ports if they do not have side effects. Lock/Unlock pairs can be nested
 * but must be balanced. BestXUnlockAll unlocks all resources by force.
 *
 * return values:
 * BX_EFW_OK
 * BX_CMDLOCKED    - the resource is already locked from another port
 * ----------------------------------------------------------------------- */

CLI  bx_errtype EXPORT BestXResourceLock (          /* @reslock */
  bx_handletype handle,
  bx_resourcetype resource          /* @res */
);

CLI  bx_errtype EXPORT BestXResourceUnlock (       /* @resunlock */
  bx_handletype handle,
  bx_resourcetype resource       /* @res */
);

CLI  bx_errtype EXPORT BestXAllResourceUnlock (      /* @allresunlock */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXResourceIsLocked (      /* @resislocked */
  bx_handletype handle,
  bx_resourcetype resource,  /* @res */
  bx_int32 *lock_count,     /* #RETURN "lock count=%d " */
  bx_porttype *lock_port      /* #RETURN "lock port=%s" */
);

/* -----------------------------------------------------------------------
 *
 * ----------------------------------------------------------------------- */

/* BestXAbstractProp...

   New 16-bit abstract property set. A makro around the BestXBaseCommand
   function to take advantage of the regular structure of property accesses.
   There are three versions of the get/set pair to transfer the values of
   a property group as condensed as possible.

   arguments:
   handle    - identifies port and hardware
   cmdcode    - 16-bit code identifying the called function
   prpid    - id that identifies the property, pass the value of the
             enum type
   prpval    - in/out, value of the property
*/

bx_errtype BestXAbstractPropByteSet (bx_handletype        handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32            prpval
);

bx_errtype BestXAbstractPropShortSet (bx_handletype    handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32            prpval
);

bx_errtype BestXAbstractPropLongSet (bx_handletype        handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32            prpval
);

bx_errtype BestXAbstractPropByteGet (bx_handletype        handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32           *prpval
);

bx_errtype BestXAbstractPropShortGet (bx_handletype    handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32           *prpval
);

bx_errtype BestXAbstractPropLongGet (bx_handletype        handle,
  bx_int16        cmdcode,
  bx_int8        prpid,
  bx_int32           *prpval
);

/*
 * SCR; this series of helper functions simplify calls to BestXBasicCommand
 * which send OR receive (NOT both) simple variables.
 * NOTE; the IN_/OUT_ macros are not used....the stream lengths are implicit.
 */

bx_errtype BestXBBCSendByte(bx_handletype handle, bx_int16 cmdcode, bx_int8ptr  pByte);
bx_errtype BestXBBCSendWord(bx_handletype handle, bx_int16 cmdcode, bx_int16 * pUWord);
bx_errtype BestXBBCSendLong(bx_handletype handle, bx_int16 cmdcode, bx_int32 * pULong);

bx_errtype BestXBBCReceiveByte(bx_handletype handle, bx_int16 cmdcode, bx_int8ptr  pByte);
bx_errtype BestXBBCReceiveWord(bx_handletype handle, bx_int16 cmdcode, bx_int16 * pUWord);
bx_errtype BestXBBCReceiveLong(bx_handletype handle, bx_int16 cmdcode, bx_int32 * pULong);


/* BestX...Copy

   These functions copy the contents of src, count times, into the destination buffer.
   The functions eliminate the endianness problem.

   Use these functions to translate data to and from the card.

   arguments:
   dest        - destination address
   src        - source address
   count        - number of distinct data items to copy from the source address to
              dest (each is sizeof(*src)); if src points to 10 longs then count = 10

   return values:
   incremented pointer to destination for subsequent calls of the copy
   functions.
   i.e. (dest + (count * sizeof(*src)))
*/

#ifdef BEST_FIRMWARE

#include <xbytestr.h>

#define BestXByteCopy(dest, src, count)        \
    (bx_int8ptr)ByteStreamPutByte (dest, src, count)

#define BestXWord2Stream(dest, src, count)    \
    (bx_int8ptr)ByteStreamPutWord (dest, src, count)

#define BestXLong2Stream(dest, src, count)    \
    (bx_int8ptr)ByteStreamPutLong (dest, src, count)

#define BestXStream2Word(dest, src, count)    \
    (bx_int8ptr)ByteStreamGetWord (src, dest, count)

#define BestXStream2Long(dest, src, count)    \
    (bx_int8ptr)ByteStreamGetLong (src, dest, count)


#else
bx_int8ptr EXPORT BestXByteCopy (bx_int8ptr dest, bx_int8ptr src, bx_int32 count);

bx_int8ptr EXPORT BestXWord2Stream (bx_int8ptr dest, bx_int16ptr src, bx_int32 count); /* num_words */
bx_int8ptr EXPORT BestXLong2Stream (bx_int8ptr dest, bx_int32ptr src, bx_int32 count); /* num_dwords */

bx_int8ptr EXPORT BestXStream2Word (bx_int16ptr dest, bx_int8ptr src, bx_int32 count); /* num_words */
bx_int8ptr EXPORT BestXStream2Long (bx_int32ptr dest, bx_int8ptr src, bx_int32 count); /* num_dwords */

#endif /* defined BEST_FIRMWARE */


#ifdef __cplusplus
}
#endif /* defined __cplusplus */

#endif /* defined XSESSION_H_INCLUDED */
